unit AppDispatch1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls,
  Common1,
  UserApp01Main, UserApp02Main, UserApp03Main;

// ==========================================================================
//      
// ==========================================================================
type TRequest = record
  RqCmd   : string;      //   
  RqPrm   : string;      //    
  Replay  : string;      //    
  //      GET
  Buffer  : pointer;     //    nil
  BufSize : integer;     //    

end;

// --------------------------------------------------------------------------
//      
function SetRequest(RqCmdInd  : integer; var RqRequest : TRequest) : boolean;

//    
procedure ShowResult(RqRequest : TRequest; RqReport : TMemo);

// ==========================================================================
// --------------------------------------------------------------------------
implementation
// --------------------------------------------------------------------------
// ==========================================================================
// --------------------------------------------------------------------------
//      
function SetRequest(RqCmdInd : integer; var RqRequest : TRequest) : boolean;
begin
  Result := False;
  //      
  FillChar(RqRequest, SizeOf(RqRequest), #0);
  //      
  with RqRequest do
  begin
     case RqCmdInd of
     0 : begin
           RqCmd   := 'GET';
           RqPrm   := 'REC1';
           Buffer  := Addr(REC1);
           BufSize := SizeOF(REC1);
           Result  := True;
         end;
     1 : begin
           RqCmd   := 'GET';
           RqPrm   := 'REC2';
           Buffer  := Addr(REC2);
           BufSize := SizeOF(REC2);
           Result  := True;
         end;
     2 : begin
           RqCmd   := 'GET';
           RqPrm   := 'REC3';
           Buffer  := Addr(REC3);
           BufSize := SizeOF(REC3);
           Result  := True;
         end;
     end;
  end;
end;
// --------------------------------------------------------------------------
//   'REC1'
procedure RunREC1(RqReport : TMemo);
var Ind : integer;
begin
   RqReport.Clear;
   with RqReport.Lines
   do begin
      Add(REC1.Id);
      for Ind := Low(REC1.Arr) to High(REC1.Arr)
      do begin
         Add(FloatToStr(REC1.Arr[Ind]));
      end;
      UserApp01Form.ShowSensors;
   end;
end;
// --------------------------------------------------------------------------
//   'REC2'
procedure RunREC2(RqReport : TMemo);
var Ind : integer;
begin
  RqReport.Clear;
  with RqReport.Lines
  do begin
    Add(REC2.Id);
    for Ind := Low(REC2.Arr) to High(REC2.Arr)
    do begin
       Add(FloatToStr(REC2.Arr[Ind]));
    end;
    UserApp02Form.ShowSensors;
  end;
end;
// --------------------------------------------------------------------------
//   'REC3'
procedure RunREC3(RqReport : TMemo);
begin
  RqReport.Clear;
  with RqReport.Lines
  do begin
    Add(REC3.Id);
    Add(FloatToStr(REC3.Pith));
    Add(FloatToStr(REC3.Roll));
    Loading.PitchAngle := REC3.Pith;
    Loading.RollAngle  := REC3.Roll;
  end;
end;
// --------------------------------------------------------------------------
//    
procedure ShowResult(RqRequest : TRequest; RqReport : TMemo);
begin
   //--------------------
   //  'GET:REC1'
   if (UpperCase(RqRequest.RqCmd) = 'GET') and
      (UpperCase(RqRequest.RqPrm) = 'REC1')
   then begin
      //   
      RunREC1(RqReport);
      Exit;
   end;
   //--------------------
   //  'GET:REC2'
   if (UpperCase(RqRequest.RqCmd) = 'GET') and
      (UpperCase(RqRequest.RqPrm) = 'REC2')
   then begin
      //   
      RunREC2(RqReport);
      Exit;
   end;
   //--------------------
   //  'GET:REC3'
   if (UpperCase(RqRequest.RqCmd) = 'GET') and
      (UpperCase(RqRequest.RqPrm) = 'REC3')
   then begin
      //   
      RunREC3(RqReport);
      Exit;
   end;
end;




end.
